#!/bin/sh
#
#         Name: install.sh (shell script)
#       Author: Rick Troth, rogue programmer
#         Date: 2023-03-22 (Wed)
#
#
#

cd `dirname "$0"`

PREFIX=/usr

while [ ! -z "$*" ] ; do
  case "$1" in
    --prefix)
      shift ; PREFIX="$1"
      ;;
    --prefix=*)
      PREFIX=`echo "$1" | awk -F= '{print $2}'`
      ;;
    *)
      echo "ignoring '$1'"
      ;;
  esac
  shift
done

#make xmitmsg xmiterr libxmitmsgx.a libxmitmsgxdyn.so \
#     xmitmsgx.h xmitmsgx.msgs errno.msgs
mkdir -p $PREFIX/bin $PREFIX/lib $PREFIX/include \
  $PREFIX/share/locale/en_US $PREFIX/sbin $PREFIX/src
cp -p xmitmsg xmiterr $PREFIX/bin/.
#cp -p libxmitmsgx.a libxmitmsgxdyn.so $PREFIX/lib/.
cp -p *.a *.so $PREFIX/lib/.
cp -p xmitmsgx.h $PREFIX/include/.
cp -p xmitmsgx.msgs errno.msgs $PREFIX/share/locale/en_US/.
cp -p xmitmivp.sh $PREFIX/sbin/.
cp -p xmitmivp.c $PREFIX/src/.

if [ -f MessageService.class ] ; then
  cp -p MessageService.class $PREFIX/com/casita/xmitmsgx/. ; fi

exit

