#!/bin/sh
#
#         Name: build-cmake.sh (shell script)
#       Author: Rick Troth, rogue programmer
#         Date: 2023-04-10 (Mon)
#

cd `dirname "$0"`

PREFIX=/usr

while [ ! -z "$*" ] ; do
  case "$1" in
    --prefix)
      shift ; PREFIX="$1"
      ;;
    --prefix=*)
      PREFIX=`echo "$1" | awk -F= '{print $2}'`
      ;;
    *)
      echo "ignoring '$1'"
      ;;
  esac
  shift
done

CFLAGS="$CFLAGS -DPREFIX=\\\"$PREFIX\\\""
export CFLAGS

# clean-up any prior build
rm -rf cm
mkdir -p cm

# copy-in the CMake support
cp -p CMakeLists.txt cm/.
cp -p install.sh cm/.

# copy-in the needed sources
cp -p xmitmsgx.h cm/.
cp -p xmitmsgx.c cm/.
cp -p xmitmsg.c cm/.
cp -p xmiterr.c cm/.
cp -p xmsgtest.c cm/.

# copy-in the message files
cp -p xmitmsgx.msgs cm/.
cp -p errno.msgs cm/.

# copy-in the installation verification program
cp -p xmitmivp.c cm/.
cp -p xmitmivp.sh cm/.

# now get into that sub-dir and do the CMake work
cd cm

cmake .
RC=$? ; if [ $RC -ne 0 ] ; then exit $RC ; fi

make
RC=$? ; if [ $RC -ne 0 ] ; then exit $RC ; fi

#cmake --install . --prefix $PREFIX
sudo ./install.sh
RC=$? ; if [ $RC -ne 0 ] ; then exit $RC ; fi

exit


CMAKE_C_FLAGS: Initialized by the CFLAGS environment variable.
CMAKE_CXX_FLAGS: Initialized by the CXXFLAGS environment variable.
CMAKE_INSTALL_PREFIX


